#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_POINTS 200000

typedef struct {
    int x, y;
} Point;

typedef struct Node {
    int x, y, count;
    struct Node* next;
} Node;

Node* hashTable[1000000];

unsigned int hash(int x, int y) {
    return (x * 31 + y) % 1000000;
}

void insert(int x, int y) {
    unsigned int h = hash(x, y);
    Node* newNode = (Node*)malloc(sizeof(Node));
    newNode->x = x;
    newNode->y = y;
    newNode->count = 1;
    newNode->next = hashTable[h];
    hashTable[h] = newNode;
}

int search(int x, int y) {
    unsigned int h = hash(x, y);
    Node* node = hashTable[h];
    while (node) {
        if (node->x == x && node->y == y)
            return node->count;
        node = node->next;
    }
    return 0;
}

void update(int x, int y) {
    unsigned int h = hash(x, y);
    Node* node = hashTable[h];
    while (node) {
        if (node->x == x && node->y == y) {
            node->count++;
            return;
        }
        node = node->next;
    }
    insert(x, y);
}

int main() {
    int n;
    scanf("%d", &n);
    
    Point points[n];
    for (int i = 0; i < n; i++) {
        scanf("%d %d", &points[i].x, &points[i].y);
    }
    
    long long totalGreetings = 0;
    
    for (int i = 0; i < n; i++) {
        int x = points[i].x;
        int y = points[i].y;
        
        int moves[4][2] = {
            {x + 1, y},
            {x - 1, y},
            {x, y + 1},
            {x, y - 1}
        };
        
        for (int j = 0; j < 4; j++) {
            totalGreetings += search(moves[j][0], moves[j][1]);
        }
        
        for (int j = 0; j < 4; j++) {
            update(moves[j][0], moves[j][1]);
        }
    }
    
    printf("%lld\n", totalGreetings);
    
    return 0;
}